<?php

namespace GoDaddy\WordPress\MWC\Core\WooCommerce\Adapters;

use GoDaddy\WordPress\MWC\Common\DataSources\WooCommerce\Adapters\Order\LineItemAdapter as CommonLineItemAdapter;
use GoDaddy\WordPress\MWC\Common\Models\Orders\LineItem;
use GoDaddy\WordPress\MWC\Core\Features\Marketplaces\Models\LineItem as MarketplacesLineItem;
use WC_Order_Item_Product;

class LineItemAdapter extends CommonLineItemAdapter
{
    /**
     * @return LineItem
     */
    public function convertFromSource() : LineItem
    {
        return parent::convertFromSource(); // TODO: Change the autogenerated stub
    }

    /**
     * @param LineItem|null $lineItem
     * @return WC_Order_Item_Product
     */
    public function convertToSource(LineItem $lineItem = null) : WC_Order_Item_Product
    {
        $wcOrderItem = $this->parentConvertToSource($lineItem);

        if ($lineItem instanceof MarketplacesLineItem && $lineItem->getOrderItemReference()) {
            $wcOrderItem->update_meta_data(
                OrderAdapter::MARKETPLACES_INTERNAL_ORDER_ITEM_ID_META_KEY,
                $lineItem->getOrderItemReference()
            );
        }

        return $wcOrderItem;
    }

    /**
     * @codeCoverageIgnore Isolated to its own test to make parent method mockable.
     * @param LineItem|null $lineItem
     * @return WC_Order_Item_Product
     */
    protected function parentConvertToSource(?LineItem $lineItem) : WC_Order_Item_Product
    {
        return parent::convertToSource($lineItem);
    }
}
