<?php
/**
 * Plugin Name: Elementor Pro Form Widget - Salesforce CRM (Premium)
 * Description: Elementor Pro Form Widget - Salesforce CRM (Premium) plugin allows you to connect WordPress Elementor Pro Form Widget and Salesforce CRM.
 * Version:     1.1.0
 * Author:      Obtain Code
 * Author URI:  https://obtaincode.net/
 * License:     GPL v2 or later
 * Text Domain: epfw_sf
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit( 'Restricted access.' );
}

/*
 * This is a constant variable for plugin path.
 */
define( 'EPFW_SF_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

/*
 * This is a file for includes API.
 */
include_once EPFW_SF_PLUGIN_PATH . 'includes/api.php';

/*
 * This is a file for includes admin.
 */
include_once EPFW_SF_PLUGIN_PATH . 'includes/admin/admin.php';

/*
 * This is a function that run when plugin activation.
 */
if ( ! function_exists( 'epfw_sf_activation' ) ) {
    register_activation_hook( __FILE__, 'epfw_sf_activation' );
    function epfw_sf_activation() {
        
        $modules = get_option( 'epfw_sf_modules' );
        if ( ! $modules ) {
            update_option( 'epfw_sf_modules', 'a:2:{s:4:"Case";a:10:{s:9:"ContactId";a:3:{s:5:"label";s:10:"Contact ID";s:4:"type";s:9:"reference";s:8:"required";i:0;}s:13:"SuppliedEmail";a:3:{s:5:"label";s:13:"Email Address";s:4:"type";s:5:"email";s:8:"required";i:0;}s:13:"SuppliedPhone";a:3:{s:5:"label";s:5:"Phone";s:4:"type";s:6:"string";s:8:"required";i:0;}s:7:"Subject";a:3:{s:5:"label";s:7:"Subject";s:4:"type";s:6:"string";s:8:"required";i:0;}s:11:"Description";a:3:{s:5:"label";s:11:"Description";s:4:"type";s:8:"textarea";s:8:"required";i:0;}s:15:"SuppliedCompany";a:3:{s:5:"label";s:7:"Company";s:4:"type";s:6:"string";s:8:"required";i:0;}s:4:"Type";a:3:{s:5:"label";s:9:"Case Type";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:6:"Status";a:3:{s:5:"label";s:6:"Status";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:6:"Reason";a:3:{s:5:"label";s:11:"Case Reason";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:8:"Priority";a:3:{s:5:"label";s:8:"Priority";s:4:"type";s:8:"picklist";s:8:"required";i:0;}}s:4:"Lead";a:24:{s:9:"FirstName";a:3:{s:5:"label";s:10:"First Name";s:4:"type";s:6:"string";s:8:"required";i:0;}s:8:"LastName";a:3:{s:5:"label";s:9:"Last Name";s:4:"type";s:6:"string";s:8:"required";i:1;}s:5:"Email";a:3:{s:5:"label";s:5:"Email";s:4:"type";s:5:"email";s:8:"required";i:0;}s:7:"Company";a:3:{s:5:"label";s:7:"Company";s:4:"type";s:6:"string";s:8:"required";i:1;}s:4:"City";a:3:{s:5:"label";s:4:"City";s:4:"type";s:6:"string";s:8:"required";i:0;}s:5:"State";a:3:{s:5:"label";s:14:"State/Province";s:4:"type";s:6:"string";s:8:"required";i:0;}s:10:"Salutation";a:3:{s:5:"label";s:10:"Salutation";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:5:"Title";a:3:{s:5:"label";s:5:"Title";s:4:"type";s:6:"string";s:8:"required";i:0;}s:7:"Website";a:3:{s:5:"label";s:7:"Website";s:4:"type";s:3:"url";s:8:"required";i:0;}s:5:"Phone";a:3:{s:5:"label";s:5:"Phone";s:4:"type";s:5:"phone";s:8:"required";i:0;}s:11:"MobilePhone";a:3:{s:5:"label";s:12:"Mobile Phone";s:4:"type";s:5:"phone";s:8:"required";i:0;}s:3:"Fax";a:3:{s:5:"label";s:3:"Fax";s:4:"type";s:5:"phone";s:8:"required";i:0;}s:6:"Street";a:3:{s:5:"label";s:6:"Street";s:4:"type";s:6:"string";s:8:"required";i:0;}s:10:"PostalCode";a:3:{s:5:"label";s:15:"Zip/Postal Code";s:4:"type";s:6:"string";s:8:"required";i:0;}s:7:"Country";a:3:{s:5:"label";s:7:"Country";s:4:"type";s:6:"string";s:8:"required";i:0;}s:11:"Description";a:3:{s:5:"label";s:11:"Description";s:4:"type";s:8:"textarea";s:8:"required";i:0;}s:10:"LeadSource";a:3:{s:5:"label";s:11:"Lead Source";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:8:"Industry";a:3:{s:5:"label";s:8:"Industry";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:6:"Rating";a:3:{s:5:"label";s:6:"Rating";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:13:"AnnualRevenue";a:3:{s:5:"label";s:14:"Annual Revenue";s:4:"type";s:8:"currency";s:8:"required";i:0;}s:17:"NumberOfEmployees";a:3:{s:5:"label";s:9:"Employees";s:4:"type";s:3:"int";s:8:"required";i:0;}s:18:"HasOptedOutOfEmail";a:3:{s:5:"label";s:13:"Email Opt Out";s:4:"type";s:7:"boolean";s:8:"required";i:0;}s:16:"HasOptedOutOfFax";a:3:{s:5:"label";s:11:"Fax Opt Out";s:4:"type";s:7:"boolean";s:8:"required";i:0;}s:9:"DoNotCall";a:3:{s:5:"label";s:11:"Do Not Call";s:4:"type";s:7:"boolean";s:8:"required";i:0;}}}' );
        }
        
        $webto_modules = get_option( 'epfw_sf_webto_modules' );
        if ( ! $webto_modules ) {
            update_option( 'epfw_sf_webto_modules', 'a:2:{s:4:"Case";a:10:{s:4:"name";a:3:{s:5:"label";s:12:"Contact Name";s:4:"type";s:6:"string";s:8:"required";i:0;}s:5:"email";a:3:{s:5:"label";s:5:"Email";s:4:"type";s:5:"email";s:8:"required";i:0;}s:5:"phone";a:3:{s:5:"label";s:5:"Phone";s:4:"type";s:6:"string";s:8:"required";i:0;}s:7:"subject";a:3:{s:5:"label";s:7:"Subject";s:4:"type";s:6:"string";s:8:"required";i:0;}s:11:"description";a:3:{s:5:"label";s:11:"Description";s:4:"type";s:8:"textarea";s:8:"required";i:0;}s:7:"company";a:3:{s:5:"label";s:7:"Company";s:4:"type";s:6:"string";s:8:"required";i:0;}s:4:"type";a:3:{s:5:"label";s:4:"Type";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:6:"status";a:3:{s:5:"label";s:6:"Status";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:6:"reason";a:3:{s:5:"label";s:11:"Case Reason";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:8:"priority";a:3:{s:5:"label";s:8:"Priority";s:4:"type";s:8:"picklist";s:8:"required";i:0;}}s:4:"Lead";a:24:{s:10:"first_name";a:3:{s:5:"label";s:10:"First Name";s:4:"type";s:6:"string";s:8:"required";i:0;}s:9:"last_name";a:3:{s:5:"label";s:9:"Last Name";s:4:"type";s:6:"string";s:8:"required";i:0;}s:5:"email";a:3:{s:5:"label";s:5:"Email";s:4:"type";s:5:"email";s:8:"required";i:0;}s:7:"company";a:3:{s:5:"label";s:7:"Company";s:4:"type";s:6:"string";s:8:"required";i:0;}s:4:"city";a:3:{s:5:"label";s:4:"City";s:4:"type";s:6:"string";s:8:"required";i:0;}s:5:"state";a:3:{s:5:"label";s:14:"State/Province";s:4:"type";s:6:"string";s:8:"required";i:0;}s:10:"salutation";a:3:{s:5:"label";s:10:"Salutation";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:5:"title";a:3:{s:5:"label";s:5:"Title";s:4:"type";s:6:"string";s:8:"required";i:0;}s:3:"url";a:3:{s:5:"label";s:7:"Website";s:4:"type";s:3:"url";s:8:"required";i:0;}s:5:"phone";a:3:{s:5:"label";s:5:"Phone";s:4:"type";s:5:"phone";s:8:"required";i:0;}s:6:"mobile";a:3:{s:5:"label";s:6:"Mobile";s:4:"type";s:5:"phone";s:8:"required";i:0;}s:3:"fax";a:3:{s:5:"label";s:3:"Fax";s:4:"type";s:5:"phone";s:8:"required";i:0;}s:6:"street";a:3:{s:5:"label";s:6:"Street";s:4:"type";s:6:"string";s:8:"required";i:0;}s:3:"zip";a:3:{s:5:"label";s:3:"Zip";s:4:"type";s:6:"string";s:8:"required";i:0;}s:7:"country";a:3:{s:5:"label";s:7:"Country";s:4:"type";s:6:"string";s:8:"required";i:0;}s:11:"description";a:3:{s:5:"label";s:11:"Description";s:4:"type";s:8:"textarea";s:8:"required";i:0;}s:11:"lead_source";a:3:{s:5:"label";s:11:"Lead Source";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:8:"industry";a:3:{s:5:"label";s:8:"Industry";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:6:"rating";a:3:{s:5:"label";s:6:"Rating";s:4:"type";s:8:"picklist";s:8:"required";i:0;}s:7:"revenue";a:3:{s:5:"label";s:14:"Annual Revenue";s:4:"type";s:8:"currency";s:8:"required";i:0;}s:9:"employees";a:3:{s:5:"label";s:9:"Employees";s:4:"type";s:3:"int";s:8:"required";i:0;}s:11:"emailOptOut";a:3:{s:5:"label";s:13:"Email Opt Out";s:4:"type";s:7:"boolean";s:8:"required";i:0;}s:9:"faxOptOut";a:3:{s:5:"label";s:11:"Fax Opt Out";s:4:"type";s:7:"boolean";s:8:"required";i:0;}s:9:"doNotCall";a:3:{s:5:"label";s:11:"Do Not Call";s:4:"type";s:7:"boolean";s:8:"required";i:0;}}}' );
        }
        
        $method = get_option( 'epfw_sf_method' );
        if ( ! $method ) {
            update_option( 'epfw_sf_method', 'api' );
        }
    }
}

/*
 * This is a function for register actions.
 */
if ( ! function_exists( 'epfw_sf_register_actions' ) ) {
    add_action( 'elementor_pro/forms/actions/register', 'epfw_sf_register_actions', 20, 1 );
    function epfw_sf_register_actions( $form_actions_registrar ) {

        $licence = get_site_option( 'epfw_sf_licence' );
        if ( $licence ) {
            include_once EPFW_SF_PLUGIN_PATH . 'includes/form-actions/case.php';
            $form_actions_registrar->register( new EPFW_SF_Case_Action_After_Submit() );

            $method = get_option( 'epfw_sf_method' );
            if ( $method == 'api' ) {
                include_once EPFW_SF_PLUGIN_PATH . 'includes/form-actions/contact.php';
                $form_actions_registrar->register( new EPFW_SF_Contact_Action_After_Submit() );
            }
            
            include_once EPFW_SF_PLUGIN_PATH . 'includes/form-actions/lead.php';
            $form_actions_registrar->register( new EPFW_SF_Lead_Action_After_Submit() );
        }
    }
}
