<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit( 'Restricted access.' );
}

/*
 * This is a class for API.
 */
if ( ! class_exists( 'EPFW_SF_API' ) ) {
    class EPFW_SF_API {

        var $url;
        var $client_id;
        var $client_secret;
        
        function __construct( $url, $client_id, $client_secret ) {
            
            $url = rtrim( $url, '/' );
            $this->url = $url;
            $this->client_id = $client_id;
            $this->client_secret = $client_secret;
        }

        function getToken( $code, $redirect_uri ) {
            
            $data = array(
                'client_id'     => $this->client_id,
                'client_secret' => $this->client_secret,
                'code'          => $code,
                'grant_type'    => 'authorization_code',
                'redirect_uri'  => $redirect_uri,
            );
            $url = $this->url.'/services/oauth2/token';
            $args = array(
                'timeout'       => 30,
                'httpversion'   => '1.0',
                'body'          => $data,
                'sslverify'     => false,
            );
            $wp_remote_response = wp_remote_post( $url, $args );
            $json_response = '';
            if ( ! is_wp_error( $wp_remote_response ) ) {
                $json_response = $wp_remote_response['body'];
            }
            
            $response = json_decode( $json_response );
            
            return $response;
        }

        function getRefreshToken( $token ) {
            
            if ( isset( $token->refresh_token ) ) {
                $data = array(
                    'client_id'     => $this->client_id,
                    'client_secret' => $this->client_secret,
                    'grant_type'    => 'refresh_token',
                    'refresh_token' => $token->refresh_token,
                );
                $url = $this->url.'/services/oauth2/token';
                $args = array(
                    'timeout'       => 30,
                    'httpversion'   => '1.0',
                    'body'          => $data,
                    'sslverify'     => false,
                );
                $wp_remote_response = wp_remote_post( $url, $args );
                $json_response = '';
                if ( ! is_wp_error( $wp_remote_response ) ) {
                    $json_response = $wp_remote_response['body'];
                }
                
                $response = json_decode( $json_response );
                if ( isset( $response->access_token ) ) {
                    $token->access_token = $response->access_token;
                    update_option( 'epfw_sf', $token );
                }
                
                return $response;
            }
        }

        function addRecord( $token, $module, $data, $form_name ) {

            $url = $token->instance_url.'/services/data/v45.0/sobjects/'.$module;
            $header = array(
                'Authorization' => $token->token_type.' '.$token->access_token,
                'Content-Type'  => 'application/json',
            );
            $data = json_encode( $data );
            $args = array(
                'timeout'       => 30,
                'httpversion'   => '1.0',
                'headers'       => $header,
                'body'          => $data,
                'sslverify'     => false,
            );
            $wp_remote_response = wp_remote_post( $url, $args );
            $json_response = '';
            if ( ! is_wp_error( $wp_remote_response ) ) {
                $json_response = $wp_remote_response['body'];
            }
            
            $response = json_decode( $json_response );
            if ( ! isset( $response->id ) && isset( $response[0] ) ) {
                $log = "Form Name: ".$form_name."\n";
                $log .= "Error Code: ".$response[0]->errorCode."\n";
                $log .= "Message: ".$response[0]->message."\n";
                $log .= "Fields: ".implode( ',', ( isset( $response[0]->fields ) ? $response[0]->fields : array() ) )."\n";
                $log .= "Date: ".date( 'Y-m-d H:i:s' )."\n\n";

                file_put_contents( EPFW_SF_PLUGIN_PATH.'api.log', $log, FILE_APPEND );
            }

            return $response;
        }

        function getModuleFields( $token, $module ) {

            $url = $token->instance_url.'/services/data/v45.0/sobjects/'.$module.'/describe';
            $header = array(
                'Authorization' => $token->token_type.' '.$token->access_token,
                'Content-Type'  => 'application/json',
            );
            $args = array(
                'timeout'       => 30,
                'httpversion'   => '1.0',
                'headers'       => $header,
                'sslverify'     => false,
            );
            $wp_remote_response = wp_remote_get( $url, $args );
            $json_response = '';
            if ( ! is_wp_error( $wp_remote_response ) ) {
                $json_response = $wp_remote_response['body'];
            }
            
            $response = json_decode( $json_response );
            if ( ! isset( $response->fields ) && isset( $response[0] ) ) {
                $log = "Error Code: ".$response[0]->errorCode."\n";
                $log .= "Message: ".$response[0]->message."\n";
                $log .= "Date: ".date( 'Y-m-d H:i:s' )."\n\n";

                file_put_contents( EPFW_SF_PLUGIN_PATH.'api.log', $log, FILE_APPEND );
            }

            $fields = array();
            if ( isset( $response->fields ) && $response->fields != null ) {
                $fields = $response->fields;
            }
            
            $filter_fields = array();
            if ( $fields != null ) {
                foreach( $fields as $field ) {
                    if ( $field->createable ) {
                        $filter_fields[$field->name] = array(
                            'label'     => $field->label,
                            'type'      => $field->type,  
                            'required'  => 1,
                        );
                        
                        if ( $field->nillable ) {
                            $filter_fields[$field->name]['required'] = 0;
                        }
                    }
                }
                
                $filter_fields['attachment_field'] = array(
                    'label'     => 'Files',
                    'type'      => 'relate',
                    'required'  => 0,
                );
            }
            
            return $filter_fields;
        }

        function getRecords( $token, $module, $fields, $where = '' ) {
            
            $query = 'SELECT+'.implode( ',', $fields ).'+FROM+'.$module;
            if ( $where ) {
                $query .= '+WHERE+'.$where;
            }
            
            $url = $token->instance_url.'/services/data/v45.0/query/?q='.$query;
            $header = array(
                'Authorization' => $token->token_type.' '.$token->access_token,
                'Content-Type'  => 'application/json',
            );
            $args = array(
                'timeout'       => 30,
                'httpversion'   => '1.0',
                'headers'       => $header,
                'sslverify'     => false,
            );
            $wp_remote_response = wp_remote_get( $url, $args );
            $json_response = '';
            if ( ! is_wp_error( $wp_remote_response ) ) {
                $json_response = $wp_remote_response['body'];
            }
            
            $response = json_decode( $json_response );
            
            return $response;
        }

        function updateRecord( $token, $module, $data, $record_id, $form_name ) {

            $url = $token->instance_url.'/services/data/v45.0/sobjects/'.$module.'/'.$record_id;
            $header = array(
                'Authorization' => $token->token_type.' '.$token->access_token,
                'Content-Type'  => 'application/json',
            );
            $data = json_encode( $data );
            $args = array(
                'method'        => 'PATCH',
                'timeout'       => 30,
                'httpversion'   => '1.0',
                'headers'       => $header,
                'body'          => $data,
                'sslverify'     => false,
            );
            $wp_remote_response = wp_remote_post( $url, $args );
            $json_response = '';
            if ( ! is_wp_error( $wp_remote_response ) ) {
                $json_response = $wp_remote_response['body'];
            }
            
            $response = json_decode( $json_response );
            if ( ! isset( $response->id ) && isset( $response[0] ) ) {
                $log = "Form Name: ".$form_name."\n";
                $log .= "Error Code: ".$response[0]->errorCode."\n";
                $log .= "Message: ".$response[0]->message."\n";
                $log .= "Fields: ".implode( ',', ( isset( $response[0]->fields ) ? $response[0]->fields : array() ) )."\n";
                $log .= "Date: ".date( 'Y-m-d H:i:s' )."\n\n";

                file_put_contents( EPFW_SF_PLUGIN_PATH.'api.log', $log, FILE_APPEND );
            }

            return $response;
        }

        function addCampaign( $token, $module, $data, $form_name ) {

            $url = $token->instance_url.'/services/data/v45.0/sobjects/'.$module;
            $header = array(
                'Authorization' => $token->token_type.' '.$token->access_token,
                'Content-Type'  => 'application/json',
            );
            $data = json_encode( $data );
            $args = array(
                'timeout'       => 30,
                'httpversion'   => '1.0',
                'headers'       => $header,
                'body'          => $data,
                'sslverify'     => false,
            );
            $wp_remote_response = wp_remote_post( $url, $args );
            $json_response = '';
            if ( ! is_wp_error( $wp_remote_response ) ) {
                $json_response = $wp_remote_response['body'];
            }
            
            $response = json_decode( $json_response );
            if ( ! isset( $response->id ) && isset( $response[0] ) ) {
                if ( $response[0]->errorCode != 'DUPLICATE_VALUE' ) {
                    $log = "Form Name: ".$form_name."\n";
                    $log .= "Error Code: ".$response[0]->errorCode."\n";
                    $log .= "Message: ".$response[0]->message."\n";
                    $log .= "Date: ".date( 'Y-m-d H:i:s' )."\n\n";

                    file_put_contents( EPFW_SF_PLUGIN_PATH.'api.log', $log, FILE_APPEND );
                }
            }

            return $response;
        }

        function addFile( $token, $data ) {
            
            $url = $token->instance_url.'/services/data/v45.0/sobjects/ContentVersion';
            $header = array(
                'Authorization' => $token->token_type.' '.$token->access_token,
                'Content-Type'  => 'multipart/form-data; boundary=add_file',
            );
            $post_data = '--add_file
Content-Disposition: form-data; name="entity_document";
Content-Type: application/json

{  
    
    "ReasonForChange" : "'.$data['Name'].'",
    "PathOnClient" : "'.$data['Name'].'"
}

--add_file
Content-Type: '.$data['Type'].'
Content-Disposition: form-data; name="VersionData"; filename="'.$data['Name'].'"

'.$data['Body'].'

--add_file--';
            $args = array(
                'timeout'       => 60,
                'httpversion'   => '1.0',
                'headers'       => $header,
                'body'          => $post_data,
                'sslverify'     => false,
            );
            $wp_remote_response = wp_remote_post( $url, $args );
            $json_response = '';
            if ( ! is_wp_error( $wp_remote_response ) ) {
                $json_response = $wp_remote_response['body'];
            }
            
            $response = json_decode( $json_response );
            
            return $response;
        }
    }
}
