<?php

namespace GoDaddy\WordPress\MWC\Core\Features\Commerce\Providers\Adapters;

use GoDaddy\WordPress\MWC\Common\Http\Contracts\ResponseContract;
use GoDaddy\WordPress\MWC\Core\Features\Commerce\Exceptions\Contracts\CommerceExceptionContract;
use GoDaddy\WordPress\MWC\Core\Features\Commerce\Exceptions\GatewayRequestException;
use GoDaddy\WordPress\MWC\Core\Features\Commerce\Providers\Adapters\Contracts\GatewayRequestAdapterContract;

abstract class AbstractGatewayRequestAdapter implements GatewayRequestAdapterContract
{
    /**
     * {@inheritDoc}
     */
    public function convertToSource(?ResponseContract $response = null)
    {
        if (! $response) {
            return null;
        }

        $this->throwIfIsErrorResponse($response);

        return $this->convertResponse($response);
    }

    /**
     * Converts gateway response to source.
     *
     * @param ResponseContract $response
     * @return mixed
     * @throws CommerceExceptionContract
     */
    abstract protected function convertResponse(ResponseContract $response);

    /**
     * @param ResponseContract $response
     *
     * @throws CommerceExceptionContract
     */
    protected function throwIfIsErrorResponse(ResponseContract $response) : void
    {
        if ($response->isError()) {
            throw new GatewayRequestException($response->getErrorMessage() ?: 'Request Error. The server responded with status: '.$response->getStatus());
        }
    }
}
