<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit( 'Restricted access.' );
}

/*
 * This is a class for Case Action.
 */
if ( ! class_exists( 'EPFW_SF_Case_Action_After_Submit' ) ) {
    class EPFW_SF_Case_Action_After_Submit extends \ElementorPro\Modules\Forms\Classes\Action_Base {
        
        public function get_name() {

            return 'epfw_sf_case';
        }

        public function get_label() {

            return esc_html__( 'Salesforce CRM - Case', 'epfw_sf' );
        }

        public function register_settings_section( $widget ) {

            $widget->start_controls_section(
                'epfw_sf_case_section',
                [
                    'label' => esc_html__( 'Salesforce CRM - Case', 'epfw_sf' ),
                    'condition' => [
                        'submit_actions' => $this->get_name(),
                    ],
                ]
            );
            
            $configuration = 1;
            $field_options = array(
                ''  => esc_html__( 'Select a field', 'epfw_sf' ),
            );
            $method = get_option( 'epfw_sf_method' );
            if ( $method == 'api' ) {
                $modules = get_option( 'epfw_sf_modules' );
                $modules = unserialize( $modules );
                $token = get_option( 'epfw_sf' );
                if ( ! $token ) {
                    $configuration = 0;
                }
            } else if ( $method == 'webto' ) {
                $webto_modules = get_option( 'epfw_sf_webto_modules' );
                $modules = unserialize( $webto_modules );
                $modules['Case']['recordType'] = array(
                    'label'     => esc_html__( 'Record Type ID', 'epfw_sf' ),
                    'type'      => 'reference',
                    'required'  => 0,
                );
                $organization_id = get_option( 'epfw_sf_organization_id' );
                if ( ! $organization_id ) {
                    $configuration = 0;
                }
            } else {
                $modules = array();
            }

            if ( isset( $modules['Case'] ) ) {
                asort( $modules['Case'] );
                foreach ( $modules['Case'] as $module_field_key => $module_field_value ) {
                    $field_options[$module_field_key.'###'.$module_field_value['type']] = $module_field_value['label'].' ('.esc_html__( 'Data Type: ', 'epfw_sf' ).$module_field_value['type'].( $module_field_value['required'] ? esc_html__( ' and Field: required)', 'epfw_sf' ) : ')' );
                }
            }
            
            if ( $configuration ) {
                if ( $method == 'api' ) {
                    $widget->add_control(
                        'epfw_sf_case_action',
                        [
                            'label'     => esc_html__( 'Action Event', 'epfw_sf' ),
                            'type'      => \Elementor\Controls_Manager::SELECT,
                            'default'   => 'create',
                            'options'   => array(
                                'create'            => esc_html__( 'Create Object Record', 'epfw_sf' ),
                                'create_or_update'  => esc_html__( 'Create/Update Object Record', 'epfw_sf' ),
                            ),
                            'separator' => 'after',
                        ]
                    );
                }

                if ( $field_options != null ) {
                    $widget->add_control(
                        'epfw_sf_case_fields',
                        [
                            'label'     => esc_html__( 'Fields', 'epfw_sf' ),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'fields' => [
                                [
                                    'name'      => 'form_field',
                                    'label'     => esc_html__( 'Form Field', 'epfw_sf' ),
                                    'type'      => \Elementor\Controls_Manager::TEXT,
                                    'default'   => esc_html__( 'Add form field ID.', 'epfw_sf' ),
                                ],
                                [
                                    'name'      => 'crm_field',
                                    'label'     => esc_html__( 'Lead Field', 'epfw_sf' ),
                                    'type'      => \Elementor\Controls_Manager::SELECT,
                                    'default'   => '',
                                    'options'   => $field_options,
                                ]
                            ],
                            'title_field' => '{{{ form_field }}}',
                        ]
                    );
                }
            } else {
                $widget->add_control(
                    'epfw_sf_case_configuration_message',
                    [
                        'type' => \Elementor\Controls_Manager::RAW_HTML,
                        'raw' => esc_html__( 'Configuration required. Elementor > Salesforce CRM', 'epfw_sf' ),
                        'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                    ]
                );
            }
            
            $widget->end_controls_section();
        }

        public function run( $record, $ajax_handler ) {

            $form_settings = $record->get( 'form_settings' );
            $fields = $record->get( 'fields' );
            $files = array();
            $api_data = array();
            if ( $fields != null ) {
                if ( isset( $form_settings['epfw_sf_case_fields'] ) && $form_settings['epfw_sf_case_fields'] != null ) {
                    foreach ( $form_settings['epfw_sf_case_fields'] as $field ) {
                        if ( isset( $field['crm_field'] ) && $field['crm_field'] && isset( $field['form_field'] ) && $field['form_field'] ) {
                            $api_field = explode( '###', $field['crm_field'] );
                            $api_field_name = $api_field[0];
                            $api_field_type = $api_field[1];

                            $field_value = array(
                                'raw_value' => ( isset( $fields[$field['form_field']] ) ? $fields[$field['form_field']]['raw_value'] : '' ),
                                'value'     => ( isset( $fields[$field['form_field']] ) ? $fields[$field['form_field']]['value'] : '' ),
                            );

                            if ( is_array( $field_value['raw_value'] ) ) {
                                $field_value['value'] = implode( ';', $field_value['raw_value'] );
                            }
    
                            if ( $api_field_type == 'boolean' ) {
                                if ( $field_value['value'] == '1' || $field_value['value'] == 'True' || $field_value['value'] == 'on' ) {
                                    $field_value['value'] = 'true';
                                } else {
                                    $field_value['value'] = 'false';
                                }
                            } else if ( $api_field_type == 'int' ) {
                                if ( $field_value['value'] ) {
                                    $field_value['value'] = (int) $field_value['value'];
                                }
                            } else if ( $api_field_type == 'currency' ) {
                                if ( $field_value['value'] ) {
                                    $field_value['value'] = (float) $field_value['value'];
                                }
                            } else if ( $api_field_type == 'date' ) {
                                if ( $field_value['value'] ) {
                                    $field_value['value'] = date( 'Y-m-d', strtotime( $field_value['value'] ) );
                                }
                            } else {
                                //
                            }
                            
                            if ( $api_field_name == 'attachment_field' ) {
                                if ( $field_value['value'] ) {
                                    $field_value['value'] = explode( ',', $field_value['raw_value'] );
                                    $files = array_merge( $files, $field_value['value'] );
                                }
                            } else {
                                $api_data[$api_field_name] = $field_value['value'];
                            }
                        }
                    }
                } else {
                    foreach ( $fields as $field_key => $field_value ) {
                        if ( isset( $form_settings['epfw_sf_case_'.$field_key] ) && $form_settings['epfw_sf_case_'.$field_key] ) {
                            $api_field = explode( '###', $form_settings['epfw_sf_case_'.$field_key] );
                            $api_field_name = $api_field[0];
                            $api_field_type = $api_field[1];
    
                            if ( is_array( $field_value['raw_value'] ) ) {
                                $field_value['value'] = implode( ';', $field_value['raw_value'] );
                            }
    
                            if ( $api_field_type == 'boolean' ) {
                                if ( $field_value['value'] == '1' || $field_value['value'] == 'True' || $field_value['value'] == 'on' ) {
                                    $field_value['value'] = 'true';
                                } else {
                                    $field_value['value'] = 'false';
                                }
                            } else if ( $api_field_type == 'int' ) {
                                if ( $field_value['value'] ) {
                                    $field_value['value'] = (int) $field_value['value'];
                                }
                            } else if ( $api_field_type == 'currency' ) {
                                if ( $field_value['value'] ) {
                                    $field_value['value'] = (float) $field_value['value'];
                                }
                            } else if ( $api_field_type == 'date' ) {
                                if ( $field_value['value'] ) {
                                    $field_value['value'] = date( 'Y-m-d', strtotime( $field_value['value'] ) );
                                }
                            } else {
                                //
                            }
                            
                            if ( $api_field_name == 'attachment_field' ) {
                                if ( $field_value['value'] ) {
                                    $field_value['value'] = explode( ',', $field_value['raw_value'] );
                                    $files = array_merge( $files, $field_value['value'] );
                                }
                            } else {
                                $api_data[$api_field_name] = $field_value['value'];
                            }
                        }
                    }
                }
            }
            
            if ( $api_data != null ) {
                $method = get_option( 'epfw_sf_method' );
                if ( $method == 'api' ) {
                    $domain = get_option( 'epfw_sf_domain' );
                    $client_id = get_option( 'epfw_sf_client_id' );
                    $client_secret = get_option( 'epfw_sf_client_secret' );
                    $salesforce = new EPFW_SF_API( $domain, $client_id, $client_secret );
                    $token = get_option( 'epfw_sf' );
                    $salesforce->getRefreshToken( $token );
                    $token = get_option( 'epfw_sf' );
                    
                    $action = $form_settings['epfw_sf_case_action'];
                    if ( $action == 'create_or_update' ) {
                        $email = ( isset( $api_data['SuppliedEmail'] ) ? $api_data['SuppliedEmail'] : '' );
                        if ( $email ) {
                            $records = $salesforce->getRecords( $token, 'Case', array( 'Id' ), "SuppliedEmail='$email'" );
                            if ( isset( $records->records ) && $records->records != null ) {
                                $record_id = $records->records[0]->Id;
                                $salesforce->updateRecord( $token, 'Case', $api_data, $record_id, $form_settings['form_name'] );
                            } else {
                                $record = $salesforce->addRecord( $token, 'Case', $api_data, $form_settings['form_name'] );
                                if ( isset( $record->id ) ) {
                                    $record_id = $record->id;
                                }
                            }
                        } else {
                            $record = $salesforce->addRecord( $token, 'Case', $api_data, $form_settings['form_name'] );
                            if ( isset( $record->id ) ) {
                                $record_id = $record->id;
                            }
                        }
                    } else {
                        $record = $salesforce->addRecord( $token, 'Case', $api_data, $form_settings['form_name'] );
                        if ( isset( $record->id ) ) {
                            $record_id = $record->id;
                        }
                    }

                    if ( $files != null && $record_id ) {
                        foreach ( $files as $file ) {
                            $file = trim( $file );
                            if ( $file ) {
                                $attachment_data = array(
                                    'Name'      => basename( $file ),
                                    'Type'      => mime_content_type( $file ),
                                    'Body'      => file_get_contents( $file ),
                                );
                                $file_record = $salesforce->addFile( $token, $attachment_data );
                                if ( isset( $file_record->id ) ) {
                                    $records = $salesforce->getRecords( $token, 'ContentVersion', array( 'ContentDocumentId' ), "Id='$file_record->id'" );
                                    if ( isset( $records->records ) && $records->records != null ) {
                                        $data = array(
                                            'ContentDocumentId' => $records->records[0]->ContentDocumentId,
                                            'LinkedEntityId'    => $record_id,
                                            'Visibility'        => 'AllUsers',
                                        );
                                        
                                        $salesforce->addRecord( $token, 'ContentDocumentLink', $data, $form_settings['form_name'] );
                                    }
                                }
                            }
                        }
                    }
                } else if ( $method == 'webto' ) {
                    $organization_id = get_option( 'epfw_sf_organization_id' );
                    $api_data['orgid'] = $organization_id;
                    $account = get_option( 'epfw_sf_account' );
                    if ( $account == 'sandbox' ) {
                        $url = 'https://test.salesforce.com/servlet/servlet.WebToCase?encoding=UTF-8';
                    } else {
                        $url = 'https://webto.salesforce.com/servlet/servlet.WebToCase?encoding=UTF-8';
                    }
                    
                    $args = array(
                        'timeout'       => 30,
                        'httpversion'   => '1.0',
                        'body'          => $api_data,
                        'sslverify'     => false,
                    );
                    wp_remote_post( $url, $args );
                } else {
                    //
                }
            }
        }

        public function on_export( $element ) {

            //
        }
    }
}
