<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit( 'Restricted access.' );
}

/*
 * This is a function that creates admin menu.
 */
if ( ! function_exists( 'epfw_sf_admin_menu' ) ) {
    add_action( 'admin_menu', 'epfw_sf_admin_menu', 999 );
    function epfw_sf_admin_menu() {

        add_submenu_page( 'elementor', esc_html__( 'Salesforce CRM', 'epfw_sf' ), esc_html__( 'Salesforce CRM', 'epfw_sf' ), 'manage_options', 'epfw_sf', 'epfw_sf_callback' );
    }
}

/*
 * This is a function for configuration.
 */
if ( ! function_exists( 'epfw_sf_callback' ) ) {
    function epfw_sf_callback() {

        if ( isset( $_POST['authorize'] ) ) {
            $method = sanitize_text_field( $_POST['epfw_sf_method'] );
            update_option( 'epfw_sf_method', $method );
            
            $account = sanitize_text_field( $_POST['epfw_sf_account'] );
            update_option( 'epfw_sf_account', $account );

            $domain = sanitize_text_field( $_POST['epfw_sf_domain'] );
            update_option( 'epfw_sf_domain', $domain );
            
            $client_id = sanitize_text_field( $_POST['epfw_sf_client_id'] );
            update_option( 'epfw_sf_client_id', $client_id );
            
            $client_secret = sanitize_text_field( $_POST['epfw_sf_client_secret'] );
            update_option( 'epfw_sf_client_secret', $client_secret );

            $organization_id = sanitize_text_field( $_POST['epfw_sf_organization_id'] );
            update_option( 'epfw_sf_organization_id', $organization_id );
            
            if ( $method == 'api' ) {
                $redirect_uri = menu_page_url( 'epfw_sf', 0 );
                $domain = rtrim( $domain, '/' );
                $url = $domain."/services/oauth2/authorize?response_type=code&client_id=$client_id&redirect_uri=$redirect_uri";
                ?>
                    <script type="text/javascript">
                        jQuery( document ).ready( function( $ ) {
                            window.location.replace( '<?php echo $url; ?>' );
                        });
                    </script>
                <?php
            } else {
                ?>
                    <div class="notice notice-success is-dismissible">
                        <p><?php esc_html_e( 'Settings saved.', 'epfw_sf' ); ?></p>
                    </div>
                <?php
            }
        } else if ( isset( $_REQUEST['code'] ) ) {
            $domain = get_option( 'epfw_sf_domain' );
            $client_id = get_option( 'epfw_sf_client_id' );
            $client_secret = get_option( 'epfw_sf_client_secret' );
            $code = sanitize_text_field( $_REQUEST['code'] );
            $redirect_uri = menu_page_url( 'epfw_sf', 0 );
            $salesforce = new EPFW_SF_API( $domain, $client_id, $client_secret );
            $token = $salesforce->getToken( $code, $redirect_uri );
            if ( isset( $token->error ) ) {
                ?>
                    <div class="notice notice-error is-dismissible">
                        <p><strong><?php esc_html_e( 'Error', 'epfw_sf' ); ?></strong>: <?php echo $token->error; ?></p>
                    </div>
                <?php
            } else {
                update_option( 'epfw_sf', $token );
                $salesforce->getRefreshToken( $token );
                $token = get_option( 'epfw_sf' );
                ?>
                    <div class="notice notice-success is-dismissible">
                        <p><?php esc_html_e( 'Configuration successful.', 'epfw_sf' ); ?></p>
                    </div>
                    <script type="text/javascript">
                        jQuery( document ).ready( function( $ ) {
                            window.setTimeout(function(){
                                window.location.replace( '<?php echo $redirect_uri; ?>' );
                            }, 3000);
                        });
                    </script>
                <?php
            }
        } else {
            //
        }

        if ( isset( $_POST['add_custom_field'] ) ) {
            $field_object = sanitize_text_field( $_POST['field_object'] );
            $field_label = sanitize_text_field( $_POST['field_label'] );
            $field_name = sanitize_text_field( $_POST['field_name'] );
            $field_type = sanitize_text_field( $_POST['field_type'] );
            $sf_fields = get_option( 'epfw_sf_webto_modules' );
            $sf_fields = unserialize( $sf_fields );
            $sf_fields[$field_object][$field_name] = array(
                'label'     => $field_label,
                'type'      => $field_type,
                'required'  => 0,
            );
            $sf_fields = serialize( $sf_fields );
            update_option( 'epfw_sf_webto_modules', $sf_fields );
        } else if ( isset( $_REQUEST['trash'] ) && $_REQUEST['trash'] ) {
            $sf_fields = get_option( 'epfw_sf_webto_modules' );
            $sf_fields = unserialize( $sf_fields );
            
            unset( $sf_fields[$_REQUEST['module']][$_REQUEST['field']] );

            $sf_fields = serialize( $sf_fields );
            update_option( 'epfw_sf_webto_modules', $sf_fields );
        } else {
            //
        }

        $method = get_option( 'epfw_sf_method' );
        if ( ! $method ) {
            $method = 'api';
        }
        
        $account = get_option( 'epfw_sf_account' );
        if ( ! $account ) {
            $account = 'production';
        }

        $domain = get_option( 'epfw_sf_domain' );
        if ( ! $domain ) {
            $domain = 'https://login.salesforce.com/';
        }

        $client_id = get_option( 'epfw_sf_client_id' );
        $client_secret = get_option( 'epfw_sf_client_secret' );
        $organization_id = get_option( 'epfw_sf_organization_id' );
        $token = get_option( 'epfw_sf' );
        if ( $method == 'api' && $token ) {
            $salesforce = new EPFW_SF_API( $domain, $client_id, $client_secret );
            $salesforce->getRefreshToken( $token );
            $token = get_option( 'epfw_sf' );
            $modules = get_option( 'epfw_sf_modules' );
            $modules = unserialize( $modules );
            foreach ( $modules as $module => $fields ) {
                $fields = $salesforce->getModuleFields( $token, $module );
                $modules[$module] = $fields;
            }

            $modules['Contact'] = $salesforce->getModuleFields( $token, 'Contact' );
            $modules = serialize( $modules );
            update_option( 'epfw_sf_modules', $modules );

            $campaigns = array(
                ''  => esc_html__( 'Select a campaign', 'epfw_sf' ),
            );
            $records = $salesforce->getRecords( $token, 'Campaign', array( 'Id', 'Name' ), '' );
            if ( isset( $records->records ) && $records->records != null ) {
                foreach ( $records->records as $record ) {
                    $campaigns[$record->Id] = $record->Name;
                }
            }

            update_option( 'epfw_sf_campaigns', $campaigns );
        }

        $licence = get_site_option( 'epfw_sf_licence' );
        ?>
            <div class="wrap">
                <h1 class="wp-heading-inline"><?php esc_html_e( 'Salesforce CRM', 'epfw_sf' ); ?></h1>
                <?php
                    if ( $licence ) {
                        ?>
                            <h2 class="wp-heading-inline"><?php esc_html_e( 'Configuration', 'epfw_sf' ); ?></h2>
                            <hr>
                            <form method="post">
                                <table class="form-table">
                                    <tbody>
                                        <tr>
                                            <th scope="row"><label><?php esc_html_e( 'Integration Method', 'epfw_sf' ); ?></label></th>
                                            <td>
                                                <fieldset>
                                                    <label><input type="radio" name="epfw_sf_method" value="api"<?php echo ( $method == 'api' ? ' checked="checked"' : '' ); ?> /> <?php esc_html_e( 'API', 'epfw_sf' ); ?></label>&nbsp;&nbsp;
                                                    <label><input type="radio" name="epfw_sf_method" value="webto"<?php echo ( $method == 'webto' ? ' checked="checked"' : '' ); ?> /> <?php esc_html_e( 'Web-to-Lead or Web-to-Case', 'epfw_sf' ); ?></label>
                                                </fieldset>
                                                <p class="description"><?php esc_html_e( 'API: Enterprise Edition, Unlimited Edition, Developer Edition and Performance Edition.', 'epfw_sf' ); ?><br><?php esc_html_e( 'Web-to-Lead or Web-to-Case: Professional Edition and Essential Edition.', 'epfw_sf' ); ?></p>
                                                <p class="description"><a href="https://help.salesforce.com/articleView?id=000326486&type=1&mode=1" target="_blank"><?php esc_html_e( 'Click here', 'epfw_sf' ); ?></a> <?php esc_html_e( 'more details.', 'epfw_sf' ); ?></p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><label><?php esc_html_e( 'Environment', 'epfw_sf' ); ?></label></th>
                                            <td>
                                                <fieldset>
                                                    <label><input type="radio" name="epfw_sf_account" value="production"<?php echo ( $account == 'production' ? ' checked="checked"' : '' ); ?> /> <?php esc_html_e( 'Production', 'epfw_sf' ); ?></label>&nbsp;&nbsp;
                                                    <label><input type="radio" name="epfw_sf_account" value="sandbox"<?php echo ( $account == 'sandbox' ? ' checked="checked"' : '' ); ?> /> <?php esc_html_e( 'Sandbox', 'epfw_sf' ); ?></label>
                                                </fieldset>
                                            </td>
                                        </tr>
                                        <tr id="epfw_sf_domain" style="display: <?php echo ( $method == 'api' ? 'table-row' : 'none' ); ?>">
                                            <th scope="row"><label><?php esc_html_e( 'Domain', 'epfw_sf' ); ?> <span class="description"><?php esc_html_e( '(required)', 'epfw_sf' ); ?></span></label></th>
                                            <td>
                                                <input class="regular-text" type="text" name="epfw_sf_domain" value="<?php echo esc_attr( $domain ); ?>" />
                                            </td>
                                        </tr>
                                        <tr id="epfw_sf_client_id" style="display: <?php echo ( $method == 'api' ? 'table-row' : 'none' ); ?>">
                                            <th scope="row"><label><?php esc_html_e( 'Consumer Key', 'epfw_sf' ); ?> <span class="description"><?php esc_html_e( '(required)', 'epfw_sf' ); ?></span></label></th>
                                            <td>
                                                <input class="regular-text" type="text" name="epfw_sf_client_id" value="<?php echo esc_attr( $client_id ); ?>" />
                                            </td>
                                        </tr>
                                        <tr id="epfw_sf_client_secret" style="display: <?php echo ( $method == 'api' ? 'table-row' : 'none' ); ?>">
                                            <th scope="row"><label><?php esc_html_e( 'Consumer Secret', 'epfw_sf' ); ?> <span class="description"><?php esc_html_e( '(required)', 'epfw_sf' ); ?></span></label></th>
                                            <td>
                                                <input class="regular-text" type="text" name="epfw_sf_client_secret" value="<?php echo esc_attr( $client_secret ); ?>" />
                                            </td>
                                        </tr>
                                        <tr id="epfw_sf_organization_id" style="display: <?php echo ( $method == 'webto' ? 'table-row' : 'none' ); ?>">
                                            <th scope="row"><label><?php esc_html_e( 'Organization ID', 'epfw_sf' ); ?> <span class="description"><?php esc_html_e( '(required)', 'epfw_sf' ); ?></span></label></th>
                                            <td>
                                                <input class="regular-text" type="text" name="epfw_sf_organization_id" value="<?php echo esc_attr( $organization_id ); ?>" />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <p>
                                    <input type='submit' class='button-primary' name="authorize" value="<?php esc_attr_e( 'Authorize', 'epfw_sf' ); ?>" />
                                </p>
                            </form>
                            <p id="epfw_sf_callback_url" style="display: <?php echo ( $method == 'api' ? 'table-row' : 'none' ); ?>"><strong><?php esc_html_e( 'Callback URL', 'epfw_sf' ); ?></strong>: <?php echo menu_page_url( 'epfw_sf', 0 ); ?></p>
                            <div id="epfw_sf_custom_fields" style="display: <?php echo ( $method == 'webto' ? 'table-row' : 'none' ); ?>">
                                <br>
                                <h2><?php esc_html_e( 'Custom Fields', 'epfw_sf' ); ?></h2>
                                <hr>
                                <form method="post">
                                    <table class="form-table">
                                        <tbody>
                                            <tr>
                                                <th scope="row"><label><?php esc_html_e( 'Object', 'epfw_sf' ); ?> <span class="description"><?php esc_html_e( '(required)', 'epfw_sf' ); ?></span></label></th>
                                                <td>
                                                    <select name="field_object" required>
                                                        <option value=""><?php esc_attr_e( 'Select an object', 'epfw_sf' ); ?></option>
                                                        <option value="Case"><?php esc_attr_e( 'Case', 'epfw_sf' ); ?></option>
                                                        <option value="Lead"><?php esc_attr_e( 'Lead', 'epfw_sf' ); ?></option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th scope="row"><label><?php esc_html_e( 'Field Label', 'epfw_sf' ); ?> <span class="description"><?php esc_html_e( '(required)', 'epfw_sf' ); ?></span></label></th>
                                                <td>
                                                    <input class="regular-text" type="text" name="field_label" value="" required />
                                                </td>
                                            </tr>
                                            <tr>
                                                <th scope="row"><label><?php esc_html_e( 'Field Name', 'epfw_sf' ); ?> <span class="description"><?php esc_html_e( '(required)', 'epfw_sf' ); ?></span></label></th>
                                                <td>
                                                    <input class="regular-text" type="text" name="field_name" value="" required />
                                                </td>
                                            </tr>
                                            <tr>
                                                <th scope="row"><label><?php esc_html_e( 'Field Type', 'epfw_sf' ); ?></label></th>
                                                <td>
                                                    <input class="regular-text" type="text" name="field_type" value="" />
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <p>
                                        <input type='submit' class='button-primary' name="add_custom_field" value="<?php esc_attr_e( 'Add Custom Field', 'epfw_sf' ); ?>" />
                                    </p>
                                </form>
                                <?php
                                    $page_url = menu_page_url( 'epfw_sf', 0 );
                                    $sf_fields = get_option( 'epfw_sf_webto_modules' );
                                    $sf_fields = unserialize( $sf_fields );
                                    if ( $sf_fields != null ) {
                                        ?>
                                            <br><br>
                                            <h3><?php esc_html_e( 'Case', 'epfw_sf' ); ?></h3>
                                            <hr>
                                            <table class="widefat striped">
                                                <thead>
                                                    <tr>
                                                        <th><?php esc_html_e( 'Field Label', 'epfw_sf' ); ?></th>
                                                        <th><?php esc_html_e( 'Field Name', 'epfw_sf' ); ?></th>       
                                                        <th><?php esc_html_e( 'Field Type', 'epfw_sf' ); ?></th>
                                                        <th><?php esc_html_e( 'Action', 'epfw_sf' ); ?></th>
                                                    </tr>
                                                </thead>
                                                <tfoot>
                                                    <tr>
                                                        <th><?php esc_html_e( 'Field Label', 'epfw_sf' ); ?></th>
                                                        <th><?php esc_html_e( 'Field Name', 'epfw_sf' ); ?></th>       
                                                        <th><?php esc_html_e( 'Field Type', 'epfw_sf' ); ?></th>
                                                        <th><?php esc_html_e( 'Action', 'epfw_sf' ); ?></th>
                                                    </tr>
                                                </tfoot>
                                                <tbody>
                                                    <?php
                                                        foreach ( $sf_fields['Case'] as $sf_field_name => $sf_field ) {
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $sf_field['label']; ?></td>
                                                                    <td><?php echo $sf_field_name; ?></td>
                                                                    <td><?php echo $sf_field['type']; ?></td>
                                                                    <td><a href="<?php echo $page_url; ?>&trash=1&module=Case&field=<?php echo $sf_field_name; ?>"><span class="dashicons dashicons-trash"></span></a></td>
                                                                </tr>
                                                            <?php
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                            <br>
                                            <h3><?php esc_html_e( 'Lead', 'epfw_sf' ); ?></h3>
                                            <hr>
                                            <table class="widefat striped">
                                                <thead>
                                                    <tr>
                                                        <th><?php esc_html_e( 'Field Label', 'epfw_sf' ); ?></th>
                                                        <th><?php esc_html_e( 'Field Name', 'epfw_sf' ); ?></th>       
                                                        <th><?php esc_html_e( 'Field Type', 'epfw_sf' ); ?></th>
                                                        <th><?php esc_html_e( 'Action', 'epfw_sf' ); ?></th>
                                                    </tr>
                                                </thead>
                                                <tfoot>
                                                    <tr>
                                                        <th><?php esc_html_e( 'Field Label', 'epfw_sf' ); ?></th>
                                                        <th><?php esc_html_e( 'Field Name', 'epfw_sf' ); ?></th>       
                                                        <th><?php esc_html_e( 'Field Type', 'epfw_sf' ); ?></th>
                                                        <th><?php esc_html_e( 'Action', 'epfw_sf' ); ?></th>
                                                    </tr>
                                                </tfoot>
                                                <tbody>
                                                    <?php
                                                        foreach ( $sf_fields['Lead'] as $sf_field_name => $sf_field ) {
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $sf_field['label']; ?></td>
                                                                    <td><?php echo $sf_field_name; ?></td>
                                                                    <td><?php echo $sf_field['type']; ?></td>
                                                                    <td><a href="<?php echo $page_url; ?>&trash=1&module=Lead&field=<?php echo $sf_field_name; ?>"><span class="dashicons dashicons-trash"></span></a></td>
                                                                </tr>
                                                            <?php
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                        <?php
                                    }
                                ?>
                            </div>
                            <div id="epfw_sf_api_error_logs" style="display: <?php echo ( $method == 'api' ? 'table-row' : 'none' ); ?>">
                                <br>
                                <h2 class="wp-heading-inline"><?php esc_html_e( 'API Error Logs', 'epfw_sf' ); ?></h2>
                                <hr>
                                <?php
                                    $file_path = EPFW_SF_PLUGIN_PATH.'api.log';
                                    if ( isset( $_POST['clear'] ) ) {
                                        $file = fopen( $file_path, 'w' );
                                        fclose( $file );
                                    }

                                    $file = fopen( $file_path, 'r' );
                                        $file_size = filesize( $file_path );
                                        if ( $file_size ) {
                                            $file_data = fread( $file, $file_size );
                                            if ( $file_data ) {
                                                echo '<pre style="overflow: scroll;max-height: 220px;">'; print_r( $file_data ); echo '</pre>';
                                                ?>
                                                    <form method="post">
                                                        <p>
                                                            <input type='submit' class='button-primary' name="clear" value="<?php esc_attr_e( 'Clear API Error Logs', 'epfw_sf' ); ?>" />
                                                        </p>
                                                    </form>
                                                <?php
                                            }
                                        } else {
                                            ?><p><?php esc_html_e( 'No API error logs found.', 'epfw_sf' ); ?></p><?php
                                        }
                                    fclose( $file );
                                ?>
                            </div>
                        <?php
                    } else {
                        ?>
                            <div class="notice notice-error is-dismissible">
                                <p><?php esc_html_e( 'Please verify purchase code.', 'epfw_sf' ); ?></p>
                            </div>
                        <?php
                    }
                ?>
                <br>
                <h2 class="wp-heading-inline"><?php esc_html_e( 'Licence Verification', 'epfw_sf' ); ?></h2>
                <hr>
                <?php
                    if ( isset( $_POST['epfw_sf_purchase_code'] ) && isset( $_POST['verify'] ) ) {
                        update_site_option( 'epfw_sf_purchase_code', $_POST['epfw_sf_purchase_code'] );
                        $data = array(
                            'sku'           => '40221155',
                            'purchase_code' => $_POST['epfw_sf_purchase_code'],
                            'domain'        => site_url(),
                            'status'        => 'verify',
                        );
                        $url = 'https://obtaincode.net/extension/';
                        $args = array(
                            'timeout'       => 30,
                            'httpversion'   => '1.0',
                            'body'          => $data,
                            'sslverify'     => false,
                        );
                        $wp_remote_response = wp_remote_post( $url, $args );
                        $json_response = '';
                        if ( ! is_wp_error( $wp_remote_response ) ) {
                            $json_response = $wp_remote_response['body'];
                        }
                        
                        $response = json_decode( $json_response );
                        if ( $response->success ) {
                            update_site_option( 'epfw_sf_licence', 1 );
                            ?>
                                <div class="notice notice-success is-dismissible">
                                    <p><?php echo $response->message; ?></p>
                                    <?php
                                        if ( isset( $response->activated ) && $response->activated ) {
                                            ?><p><strong><?php esc_html_e( 'Activated', 'epfw_sf' ); ?></strong>: <?php echo $response->activated; ?></p><?php
                                        }
                                    ?>
                                </div>
                            <?php
                        } else {
                            update_site_option( 'epfw_sf_licence', 0 );
                            ?>
                                <div class="notice notice-error is-dismissible">
                                    <p><?php echo $response->message; ?></p>
                                    <?php
                                        if ( isset( $response->activated ) && $response->activated ) {
                                            ?><p><strong><?php esc_html_e( 'Activated', 'epfw_sf' ); ?></strong>: <?php echo $response->activated; ?></p><?php
                                        }
                                    ?>
                                </div>
                            <?php
                        }
                    } else if ( isset( $_POST['epfw_sf_purchase_code'] ) && isset( $_POST['unverify'] ) ) {
                        $data = array(
                            'sku'           => '40221155',
                            'purchase_code' => $_POST['epfw_sf_purchase_code'],
                            'domain'        => site_url(),
                            'status'        => 'unverify',
                        );
                        $url = 'https://obtaincode.net/extension/';
                        $args = array(
                            'timeout'       => 30,
                            'httpversion'   => '1.0',
                            'body'          => $data,
                            'sslverify'     => false,
                        );
                        $wp_remote_response = wp_remote_post( $url, $args );
                        $json_response = '';
                        if ( ! is_wp_error( $wp_remote_response ) ) {
                            $json_response = $wp_remote_response['body'];
                        }
                        
                        $response = json_decode( $json_response );
                        if ( $response->success ) {
                            update_site_option( 'epfw_sf_licence', 0 );
                            update_site_option( 'epfw_sf_purchase_code', '' );
                            ?>
                                <div class="notice notice-success is-dismissible">
                                    <p><?php echo $response->message; ?></p>
                                    <?php
                                        if ( isset( $response->activated ) && $response->activated ) {
                                            ?><p><strong><?php esc_html_e( 'Activated', 'epfw_sf' ); ?></strong>: <?php echo $response->activated; ?></p><?php
                                        }
                                    ?>
                                </div>
                            <?php
                        } else {
                            ?>
                                <div class="notice notice-error is-dismissible">
                                    <p><?php echo $response->message; ?></p>
                                    <?php
                                        if ( isset( $response->activated ) && $response->activated ) {
                                            ?><p><strong><?php esc_html_e( 'Activated', 'epfw_sf' ); ?></strong>: <?php echo $response->activated; ?></p><?php
                                        }
                                    ?>
                                </div>
                            <?php
                        }
                    }
                    
                    $purchase_code = get_site_option( 'epfw_sf_purchase_code' );
                ?>
                <form method="post">
                    <table class="form-table">                    
                        <tbody>
                            <tr>
                                <th scope="row"><?php esc_html_e( 'Purchase Code', 'epfw_sf' ); ?></th>
                                <td>
                                    <input name="epfw_sf_purchase_code" type="text" class="regular-text" value="<?php echo $purchase_code; ?>" />
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <p>
                        <input type='submit' class='button-primary' name="verify" value="<?php esc_html_e( 'Verify', 'epfw_sf' ); ?>" />
                        <input type='submit' class='button-primary' name="unverify" value="<?php esc_html_e( 'Unverify', 'epfw_sf' ); ?>" />
                    </p>
                </form>
                <script>
                    jQuery( document ).ready( function( $ ) {
                        $( 'input[name="epfw_sf_method"]' ).on( 'change', function() {
                            var method = $( this ).val();
                            if ( method == 'api' ) {
                                $( '#epfw_sf_domain' ).show();
                                $( '#epfw_sf_client_id' ).show();
                                $( '#epfw_sf_client_secret' ).show();
                                $( '#epfw_sf_callback_url' ).show();
                                $( '#epfw_sf_api_error_logs' ).show();
                                
                                $( '#epfw_sf_organization_id' ).hide();
                                $( '#epfw_sf_custom_fields' ).hide();
                            } else {
                                $( '#epfw_sf_organization_id' ).show();
                                $( '#epfw_sf_custom_fields' ).show();

                                $( '#epfw_sf_domain' ).hide();
                                $( '#epfw_sf_client_id' ).hide();
                                $( '#epfw_sf_client_secret' ).hide();
                                $( '#epfw_sf_callback_url' ).hide();
                                $( '#epfw_sf_api_error_logs' ).hide();
                            }
                        });
                    });
                </script>
            </div>
        <?php
    }
}
