<?php

namespace DynamicOOOS\TelegramBot\Api\Types\Inline\QueryResult;

use DynamicOOOS\TelegramBot\Api\Types\Inline\InlineKeyboardMarkup;
use DynamicOOOS\TelegramBot\Api\Types\Inline\InputMessageContent;
/**
 * Class InlineQueryResultArticle
 * Represents a link to an article or web page.
 *
 * @package TelegramBot\Api\Types\Inline
 */
class Article extends AbstractInlineQueryResult
{
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $requiredParams = ['type', 'id', 'title', 'input_message_content'];
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $map = ['type' => \true, 'id' => \true, 'title' => \true, 'input_message_content' => InputMessageContent::class, 'reply_markup' => InlineKeyboardMarkup::class, 'url' => \true, 'hide_url' => \true, 'description' => \true, 'thumb_url' => \true, 'thumb_width' => \true, 'thumb_height' => \true];
    /**
     * {@inheritdoc}
     *
     * @var string
     */
    protected $type = 'article';
    /**
     * Optional. URL of the result
     *
     * @var string|null
     */
    protected $url;
    /**
     * Optional. Pass True, if you don't want the URL to be shown in the message
     *
     * @var bool|null
     */
    protected $hideUrl;
    /**
     * Optional. Short description of the result
     *
     * @var string|null
     */
    protected $description;
    /**
     * Optional. Url of the thumbnail for the result
     *
     * @var string|null
     */
    protected $thumbUrl;
    /**
     * Optional. Thumbnail width
     *
     * @var int|null
     */
    protected $thumbWidth;
    /**
     * Optional. Thumbnail height
     *
     * @var int|null
     */
    protected $thumbHeight;
    /**
     * InlineQueryResultArticle constructor.
     *
     * @param string $id
     * @param string $title
     * @param string|null $description
     * @param string|null $thumbUrl
     * @param int|null $thumbWidth
     * @param int|null $thumbHeight
     * @param InputMessageContent $inputMessageContent
     * @param InlineKeyboardMarkup|null $inlineKeyboardMarkup
     */
    public function __construct($id, $title, $description = null, $thumbUrl = null, $thumbWidth = null, $thumbHeight = null, $inputMessageContent = null, $inlineKeyboardMarkup = null)
    {
        parent::__construct($id, $title, $inputMessageContent, $inlineKeyboardMarkup);
        $this->description = $description;
        $this->thumbUrl = $thumbUrl;
        $this->thumbWidth = $thumbWidth;
        $this->thumbHeight = $thumbHeight;
    }
    /**
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * @param string|null $url
     *
     * @return void
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }
    /**
     * @return bool|null
     */
    public function isHideUrl()
    {
        return $this->hideUrl;
    }
    /**
     * @param bool|null $hideUrl
     *
     * @return void
     */
    public function setHideUrl($hideUrl)
    {
        $this->hideUrl = $hideUrl;
    }
    /**
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * @param string|null $description
     *
     * @return void
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }
    /**
     * @return string|null
     */
    public function getThumbUrl()
    {
        return $this->thumbUrl;
    }
    /**
     * @param string|null $thumbUrl
     *
     * @return void
     */
    public function setThumbUrl($thumbUrl)
    {
        $this->thumbUrl = $thumbUrl;
    }
    /**
     * @return int|null
     */
    public function getThumbWidth()
    {
        return $this->thumbWidth;
    }
    /**
     * @param int|null $thumbWidth
     *
     * @return void
     */
    public function setThumbWidth($thumbWidth)
    {
        $this->thumbWidth = $thumbWidth;
    }
    /**
     * @return int|null
     */
    public function getThumbHeight()
    {
        return $this->thumbHeight;
    }
    /**
     * @param int|null $thumbHeight
     *
     * @return void
     */
    public function setThumbHeight($thumbHeight)
    {
        $this->thumbHeight = $thumbHeight;
    }
}
